<?php

/**
 * Class that operate on table 'productionout'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-10-26 23:15
 */
class ProductionoutMySqlExtDAO extends ProductionoutMySqlDAO {

    public function queryAllExt($queryString = '') {
        $sql = 'SELECT productionout.*,product.productName,productcat.productCatName,size.name as sizeName,color.name as colorName,supplier.suppliername
                ,storeout.storeName as storeNameOut,storein.storeName as storeNameIn
                FROM productionout
                JOIN product	ON product.productId = productionout.productid
                JOIN productcat ON product.productCatId = productcat.productCatId
                left join sizecolor as size ON size.id=productionout.sizeid
                left join sizecolor as color ON color.id=productionout.colorid
                join supplier ON supplier.supplierid = productionout.supplier
                join store as storeout ON storeout.storeId=productionout.outStore
                join store as storein ON storein.storeId=productionout.inStore
                where 1 ' . $queryString;
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function insertWithId($productionout) {
        $sql = 'INSERT INTO productionout (id, outStore, inStore, supplier, productid, sizeid, colorid, outQuantity, outUnitCost, outAllCost, comment, userid, sysDate, del,outAllCostTot) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionout->id);
        $sqlQuery->setNumber($productionout->outStore);
        $sqlQuery->setNumber($productionout->inStore);
        $sqlQuery->setNumber($productionout->supplier);
        $sqlQuery->setNumber($productionout->productid);
        $sqlQuery->setNumber($productionout->sizeid);
        $sqlQuery->setNumber($productionout->colorid);
        $sqlQuery->set($productionout->outQuantity);
        $sqlQuery->set($productionout->outUnitCost);
        $sqlQuery->set($productionout->outAllCost);
        $sqlQuery->set($productionout->comment);
        $sqlQuery->setNumber($productionout->userid);
        $sqlQuery->set($productionout->sysDate);
        $sqlQuery->setNumber($productionout->del);
        $sqlQuery->setNumber($productionout->outAllCostTot);

        $id = $this->executeInsert($sqlQuery);
        $productionout->id = $id;
        return $id;
    }

}

?>